// Copyright (c) 2007 ie7pro@gmail.com
// Copyright (c) 2005 trixiedev@gmail.com
// This script is licensed under the MIT license.  See
// http://opensource.org/licenses/mit-license.php for more details.
//
// ==UserScript==
// @name          Google Images NoFrame link
// @namespace     http://iescripts.org/
// @description	  Adds a noframe link to images in Google Images search results
// @include       http://images.google.*/*
// ==/UserScript==

//
// IE7pro Script, ported from
//      Discussion forum: http://groups.yahoo.com/group/trixieUsers/
//

(function() 
{

	function GetImageUrl(theUrl)
	{
		if (theUrl == null)
			return(false);

		// Looking for "imgurl=..."
		var searchStr = "imgurl=";
		var pos = theUrl.indexOf(searchStr);
		var temp = null;

		if (pos >= 0){
 	   		temp = theUrl.substring(pos + searchStr.length);
			var p = temp.indexOf('&imgrefurl=');
			if(p != -1){
				temp = temp.substr(0, p);
			}
		}
		
		return temp;
	}
	
	function MakeNoFrameLink(url)
	{
	    if (url != null && url.length > 0)
	    {
			var container = document.createElement("span");
			container.appendChild(document.createTextNode(" "));
			
			var newLink = document.createElement("a");
			newLink.setAttribute("href", url);
			newLink.setAttribute("target", "_blank");
			newLink.appendChild(document.createTextNode("[nf]"));
			container.appendChild(newLink);
			
			return container;
	    }
	    
	    return null;
	}

	var hyperlinks = document.getElementsByTagName("a");
	//PRO_log("enter");

	for (var i = 0; i < hyperlinks.length; ++i)
	{
		var node = hyperlinks[i];
		var href = node.getAttribute("href");

		var imgUrl = GetImageUrl(href);
		if (imgUrl != null)
		{
		    var link = MakeNoFrameLink(imgUrl);
		    
		    if (link != null)
		    {
				if (node.nextSibling == null)
					node.parentNode.appendChild(link);
				else
					node.parentNode.insertBefore(link, node.nextSibling);
		    }
		}
	}
})();
