﻿

//initialize the findLocation window
function init() {
	var currentSetting=PRO_getValue("weather_Location","");
	if (currentSetting!="") {
	  PRO_log(currentSetting);
	  arr = currentSetting.split("|");
	  if(arr[3])
		  envVar.innerText=arr[3];
		else
		  envVar.innerText=currentSetting;
	}
	var currentUnit=PRO_getValue("weather_Unit","");
	if (currentUnit!="english") {
	  metric.checked = true;	
	}else{
          english.checked = true;	
  }
	var currentDate=PRO_getValue("weather_date_format","");
	if (currentDate=="usdate") {
	  usdate.checked = true;	
	}else if (currentDate=="shtusdate"){
	  shtusdate.checked = true;	
	}else if (currentDate=="intdate"){
	  intdate.checked = true;	
	}else{
          shtintdate.checked = true;	
  }
	var currentUnit=PRO_getValue("weather_city_display","");
	if (currentUnit!="showcity") {
	  hidecity.checked = true;	
	}else{
          showcity.checked = true;	
  }

	var currentFont=PRO_getValue("weather_font","");
	if (currentFont==1) {
	  fontcb.checked = true;	
	}else{
          fontcb.checked = false;	
  }

	var currentCity=PRO_getValue("weather_City","");
	var currentState=PRO_getValue("weather_State","");
	if (currentCity!="") {
		CurrentLocation.innerText="Current location saved: " + currentCity + ", " + currentState;
	}else{
		CurrentLocation.innerText="No location saved yet.";
  }

}

//load the xml data from the website
function loadData() {
	req = PRO_xmlhttpRequest();
	if (req) {
		req.open("GET","http://vwidget.accuweather.com/widget/vista1/locate_city.asp?location=" + envVar.value,true);
		req.onreadystatechange=processData;
		req.send();
	}
}

//process data when its received
function processData() {
	if (req.readyState==4) {
		if (req.status==200) {
			parseData(req.responseXML.documentElement);
		}
	}
}

//parse the xml data and populate the table with data.
function parseData(xmlData) {
	tempNode=xmlData.getElementsByTagName("./citylist").item(0);
	tempNodes=tempNode.getElementsByTagName('location');
	deleteRows("LocationTable");
	for (count=0;count<tempNodes.length;count++) {
		cityNode=tempNodes[count];
		tempString="<a class=\"link\" href=\"#\" onClick=\"selectLocation('" + cityNode.getAttribute("location") + "');selectLocationState('" + cityNode.getAttribute("state") + "');selectLocationCity('" + cityNode.getAttribute("city") + "');return false;\">+</a>&nbsp;&nbsp;";
		tempString1="<a class=\"link\" href=\"#\" onClick=\"selectLocation('" + cityNode.getAttribute("location") + "');selectLocationState('" + cityNode.getAttribute("state") + "');selectLocationCity('" + cityNode.getAttribute("city") + "');return false;\">" + cityNode.getAttribute("city") + ", " + cityNode.getAttribute("state") + "</a>";
		addRow("LocationTable",tempString,tempString1);
	}
//	tempString1 += "<br><br>";
	if (tempNodes.length==0) {
		addRow("LocationTable","Location not found","");
		scrollTableText.innerText="";
	} else {
		scrollTableText.innerText="Click on location to save.";
	}
	with (scrollTableContainer.style) {
		display="block";
	}
}

//add a row programatically to a table
function addRow(id,value,text){
	var tbody=document.getElementById(id).getElementsByTagName("tbody")[0];
	var row=document.createElement("TR");
	var cell1=document.createElement("TD");
	cell1.innerHTML=value;
	cell1.style.whiteSpace="nowrap";
	var cell2=document.createElement("TD");
	cell2.innerHTML=text;
	cell2.style.whiteSpace="nowrap";
	row.appendChild(cell1);
	row.appendChild(cell2);
	tbody.appendChild(row);
}

//delete a row from a table
function deleteRows(id) {  
	var tbl=document.getElementById(id);
	totalRows=tbl.rows.length;
	for (count=0;count<totalRows;count++) {
		document.getElementById(id).deleteRow(0);
	}
}

//if a location is selected save it to the settings and close the flyout
function selectLocation(locationCode) {
	PRO_setValue("weather_Location",locationCode);
//	alert("Location Saved. \rSettings window will now close.");
}
function selectLocationState(locationState) {
	PRO_setValue("weather_State",locationState);
	this.locstate=locationState;
}
function selectLocationCity(locationCity) {
	PRO_setValue("weather_City",locationCity);
	CurrentLocation.innerText="Current location saved: " + locationCity + ", " + locstate;
	var answer = confirm("Location Saved.\rPress 'OK' if done\rPress 'Cancel' to select other options.")
	if (answer)window.close();
}
function selectUnit(Unit) {
	PRO_setValue("weather_Unit",Unit);
//	PRO_log("set weather_Unit " + Unit)
	//alert("Unit Selected. ");
}
function selectDate(Date1) {
	PRO_setValue("weather_date_format",Date1);
//	PRO_log("set weather_date_format " + Date1)
}
function selectCity(City1) {
	PRO_setValue("weather_city_display",City1);
//	PRO_log("set weather_city_display " + City1)
}

function selectFont(font1) {
if (fontcb.checked){
	PRO_setValue("weather_font",1);
}else{
	PRO_setValue("weather_font",0);
}
}
